/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateHole.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFeature.h"
#include "CApplication.h"

//	Creates a Hole on a top face and return hole created.
HRESULT CreateHole(ISketch *pSk, ISet *pFaces, int below, long holeType, long extent, double holeDia, double holeDepth, double taperRatio, double countDiam, double countDepth, double countAngle, double drillAngle, CString holeName, IHole **pHole)
{

	START_METHOD("CreateHole")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign = NULL;
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	//perform operation to create hole
	IHole *hole = NULL;
	status = (GetCLASS(Hole))->CreateHole(pDesign, pSk, CAST(IObjectOrSet, pFaces), below, holeType, extent, holeDia, holeDepth, taperRatio, countDiam, countDepth, countAngle, drillAngle, FALSE, &hole);
	CHECK_RETURN_STATUS(status)

	IOperation *operation = CAST(IOperation, hole);

	status = operation->SetName(holeName.AllocSysString());
	CHECK_RETURN_STATUS(status)

	// return the pointer
	*pHole = hole;
	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	END_METHOD("CreateHole")
}
